 ; Ŀ
 ;   Door - install a doorway.                                             
 ;   Copyright 2005 by Rocket Software Ltd.                                
 ;   3M has quietly suppressed the Post-it Note rifle, Post-it Note        
 ;   confetti, and the combination Cellphone and Post-it Note printer.     
 ; 

 ; Ŀ
 ;   Subroutine Dor - install a doorway in a single line wall.             
 ;   Arguments: Phinge, the hinge point.                                   
 ;              Popp, the point on the other side of the frame.            
 ;   Calls Droar, Joina, and Iri.                                          
 ;   Reyurns nothing.                                                      
 ; 
 (DEFUN DOR (phinge popp / drang angg dwidth dwidp numdor prom nump enam
                                                               elprev gnunam)
  (setq drang (angle phinge popp))
 ; Ŀ
 ;   Get a door angle.                                                     
 ; 
  (setq angg (getangle phinge "Door angle: "))
 ; Ŀ
 ;   Ask if the door width needs to be adjusted.                           
 ; 
  (setq dwidth (distance phinge popp))
  (setq dwidp (strcat "\nDoor width <" (rtos dwidth) ">: "))
  (if (setq dwidp (getdist phinge dwidp))
      (progn
           (setq dwidth dwidp)
           (setq popp (polar phinge (angle phinge popp) dwidth))))
 ; Ŀ
 ;   See how many doors to make.                                           
 ; 
  (setq numdor (if (> dwidth 1200) 2 1))
  (setq prom (strcat "Number of doors ("
                      (if (= numdor 1) "<1>/2" "1/<2>") "): "))
  (setq nump (getint prom))
  (if nump (setq numdor nump))
 ; Ŀ
 ;   Break the wall.                                                       
 ; 
  (setq enam (car (nentselp phinge)))
  (setq elprev (entlast))
  (command ".break" (list enam phinge) "f" popp phinge)
  (grdraw popp phinge 8 1)
 ; Ŀ
 ;   If this created a new entity then gnunam will contain its name,       
 ;   otherwise nil.                                                        
 ; 
  (if (not (equal elprev (entlast)))
      (setq gnunam (entlast)))
 ; Ŀ
 ;   Draw one door.                                                        
 ; 
  (if (= numdor 1)
      (droar phinge popp dwidth angg)
 ; Ŀ
 ;   Draw two doors: split the opening in half and draw the arc and line   
 ;   set for each side.                                                    
 ; 
      (progn
           (setq dwidth (/ dwidth 2))
           (setq popp (polar phinge drang dwidth))
           (droar phinge popp dwidth angg)
           (setq gnunam (entlast))
           (command "mirror" gnunam "" popp
                                 (polar popp (+ drang (/ pi 2)) 10) "")
 ; Ŀ
 ;   Join the two door and arc sets together.                              
 ; 
           (joina gnunam (list (entlast)))))
 (princ))
 ; Ŀ
 ;   Subroutine Dor end.                                                   
 ; 

 ; Ŀ
 ;   Droar: draw a single door line and arc.                               
 ;   Arguments: Phinge, the original hinge point.                          
 ;              Popp, the point opposite the hinge.                        
 ;              Dwidth, the door width.                                    
 ;              Dang, the door angle.                                      
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN DROAR (phinge popp dwidth dang / pend pmid)
 ; Ŀ
 ;   Get the door arc midpoint.                                            
 ; 
  (setq pend (polar phinge dang dwidth))
  (setq pmid (polar popp (angle popp pend) (/ (distance popp pend) 2)))
  (setq pmid (polar phinge (angle phinge pmid) dwidth))
 ; Ŀ
 ;   Draw some temporary lines.                                            
 ; 
  (grdraw pend popp 8 1)
  (grdraw phinge pmid 8 1)
 ; Ŀ
 ;   Draw the polyline and arc.                                            
 ; 
  (iri phinge dwidth 256 251)
  (command ".pline" phinge pend "a" "s" pmid popp "")
 (princ))
 ; Ŀ
 ;   Droar end.                                                            
 ; 

 ; Ŀ
 ;   Droor: draw a single door line and arc.                               
 ;   Arguments: Phinge, the original hinge point.                          
 ;              Phing2, the other side of the wall from the hinge.         
 ;              Popp, the point diagonally opposite the hinge.             
 ;              Popp2, the point through the wall from Popp, in other      
 ;                     words on the same side of the wall as the hinge,    
 ;                     but on the opposite side of the door opening.       
 ;              Dwidth, the door width.                                    
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN DROOR (phinge phing2 popp popp2 dwidth / anga angb p1 p2 pmid pend)
 ; Ŀ
 ;   Get the door angle.                                                   
 ; 
  (setq anga (angle phinge popp2))
  (setq angb (angle phing2 phinge))
  (setq p1 (polar phinge anga dwidth))
  (setq p2 (polar phinge angb dwidth))
  (setq pmid (polar p1 (angle p1 p2) (/ (distance p1 p2) 2)))
  (setq pend (polar phinge (angle phinge pmid) dwidth))
 ; Ŀ
 ;   Find the arc midpoint.                                                
 ; 
  (grdraw pend popp2 8 1)
  (setq pmid (polar popp2 (angle popp2 pend) (/ (distance popp2 pend) 2)))
  (setq pmid (polar phinge (angle phinge pmid) dwidth))
  (grdraw phinge pmid 8 1)
 ; Ŀ
 ;   Draw the polyline and arc.                                            
 ; 
  (iri phinge dwidth 256 251)
  (command ".pline" phinge pend "a" "s" pmid popp2 "")
 (princ))
 ; Ŀ
 ;   Droor end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Iri - grdraw circle maker with gaps.                       
 ; 
 (DEFUN IRI (pa radd reps colo / skip angg incr pa1 pa2)
  (setq skip 0)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (while (< 0 reps)
         (setq reps (1- reps))
         (setq angg (+ angg incr))
         (setq pa2 (polar pa angg radd))
         (setq skip (abs (1- skip)))
         (if (not (zerop skip))
             (grdraw pa1 pa2 colo))
         (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Iri end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Joina - add or make a number of entities into a polyline.  
 ;   Arguments: Enam, the base entity name.                                
 ;              Lisa, alist of entity names.                               
 ;   Calls nothing, Returns nothing.                                       
 ; 
 (DEFUN JOINA (enam lisa / ss num aaa typ)
  (setq ss (ssadd))
  (setq num 0)
  (while (setq aaa (nth num lisa))
         (setq num (1+ num))
         (ssadd aaa ss))
  (setq typ (cdr (assoc 0 (entget enam))))
  (if (or (= typ "POLYLINE") (= typ "LWPOLYLINE"))
      (command "pedit" enam "j" ss "" "")
      (command "pedit" enam "y" "j" ss "" ""))
 (princ))
 ; Ŀ
 ;   Subroutine Joina end.                                                 
 ; 

 ; Ŀ
 ;   Tudor - install a doorway in a two-line wall.                         
 ;   Arguments: Phinge, the hinge point.                                   
 ;              Hangg, the angle of the wall on which the hinge resides.   
 ;              Popp, the point on the other side of the wall and on the   
 ;                    other side of the frame from the hinge point.        
 ;              Othang, the angle of the opposite side of the wall.        
 ;   Calls Droor and Iri and Joina.  Returns nothing.                      
 ; 
 (DEFUN TUDOR (phinge hangg popp othang / popp2 phing2 dwidth dwidp numdor
                           prom nump enam2 elprev gnunam linam1 linam2 phinge)
 ; Ŀ
 ;   Get the opposite side of the opening on the same wall surface as      
 ;   the hinge - i.e. going across the width of the door.                  
 ; 
  (setq popp2 (inters phinge pb popp (polar popp (+ othang (/ pi 2)) 10) nil))
 ; Ŀ
 ;   Get the other side of the jamb from the hinge, going at a right       
 ;   angle through the wall.                                               
 ; 
  (setq phing2 (inters phinge (polar phinge (+ hangg (/ pi 2)) 10)
                       popp pd nil))
 ; Ŀ
 ;   See if the user wants to adjust the door width.                       
 ;   The hinge point is fixed, the other jamb moves if required.           
 ; 
  (setq dwidth (distance phinge popp2))
  (setq dwidp (strcat "\nDoor width <" (rtos dwidth) ">: "))
  (if (setq dwidp (getdist phinge dwidp))
      (progn
           (setq dwidth dwidp)
           (setq popp2 (polar phinge (angle phinge popp2) dwidth))
           (setq popp (polar phing2 (angle phing2 popp) dwidth))))
 ; Ŀ
 ;   See how many doors to make.                                           
 ; 
  (setq numdor (if (> dwidth 1200) 2 1))
  (setq prom (strcat "Number of doors ("
                      (if (= numdor 1) "<1>/2" "1/<2>") "): "))
  (setq nump (getint prom))
  (if nump (setq numdor nump))
 ; Ŀ
 ;   Draw a few decorative lines.                                          
 ; 
  (grdraw phinge popp 8 1)
  (grdraw phing2 popp2 8 1)
 ; Ŀ
 ;   Break the wall.                                                       
 ; 
  (setq enam2 (car (nentselp popp)))
  (setq elprev (entlast))
  (command ".break" (list enam2 popp) "f" popp phing2)
  (grdraw popp phing2 8 1)
 ; Ŀ
 ;   If this created a new entity then gnunam will contain its name,       
 ;   otherwise nil.                                                        
 ; 
  (if (not (equal elprev (entlast)))
      (setq gnunam (entlast)))
 ; Ŀ
 ;   Draw the doorjamb lines.                                              
 ; 
  (command ".line" popp popp2 "")
  (setq linam1 (entlast))
  (command ".line" phinge phing2 "")
  (setq linam2 (entlast))
 ; Ŀ
 ;   Join them to the inside wall lines.                                   
 ; 
  (joina enam2 (list linam1 linam2))
  (cond ((and gnunam (entget linam1))
         (joina gnunam (list linam1)))
        ((and gnunam (entget linam2))
         (joina gnunam (list linam2))))
 ; Ŀ
 ;   Draw one door.                                                        
 ; 
  (if (= numdor 1)
      (droor phinge phing2 popp popp2 dwidth)
 ; Ŀ
 ;   Draw two doors: split the opening in half and draw the arc and line   
 ;   set for each side.                                                    
 ; 
      (progn
           (setq dwidth (/ dwidth 2))
           (setq popp2 (polar phinge (angle phinge popp2) dwidth))
           (setq popp (polar phing2 (angle phing2 popp) dwidth))
           (droor phinge phing2 popp popp2 dwidth)
           (setq gnunam (entlast))
           (setq phinge (polar popp2 (angle phinge popp2) dwidth))
           (setq phing2 (polar popp (angle phing2 popp) dwidth))
           (droor phinge phing2 popp popp2 dwidth)
 ; Ŀ
 ;   Join the two door and arc sets together.                              
 ; 
           (joina gnunam (list (entlast)))))
 (princ))
 ; Ŀ
 ;   Tudor end.                                                            
 ; 

 ; Ŀ
 ;   Door.                                                                 
 ; 
 (DEFUN C:DOOR (/ aperture osmo *error* phinge pb hangg popp pd othang)
  (command "undo" "be")
  (setq aperture (getvar "aperture"))
  (setvar "aperture" 5)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "aperture" aperture)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get the location of the hinge.                                        
 ; 
  (setq phinge (getpoint "Hinge location: "))
  (if (setq pb (osnap phinge "nea")) (setq phinge pb))
  (setq pb (osnap phinge "end"))
  (setq hangg (angle phinge pb))
 ; Ŀ
 ;   Get the point diagonally opposite the hinge on the doorframe opening. 
 ; 
  (setq popp (getpoint phinge "Opposite Corner of Doorway: "))
  (if (setq pd (osnap popp "nea")) (setq popp pd))
  (setq pd (osnap popp "end"))
  (setq othang (angle popp pd))
 ; Ŀ
 ;   Call Tudor to make the door:                                          
 ; 
  (if (equal (car (nentselp popp)) (car (nentselp phinge)))
 ; Ŀ
 ;   In a single line wall.                                                
 ; 
      (dor phinge popp)
 ; Ŀ
 ;   In a two line wall.                                                   
 ; 
      (tudor phinge hangg popp othang))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* "")
 (princ))